﻿var currItem = 0;
var timeout = 5;
var slideSpeed = 1;
var slideStep = 5;
var rssBoxPadding = 3;

function startRequest(param)
{
  var rssDiv = document.getElementById("rssBox");
  rssDiv.innerHTML = "Trwa wczytywanie danych...";
  url = "http://localhost/dane.php?url=" + param;
  startGETRequest(url, onComplete, onEnd);
}

function startRSSShow()
{
  var rssBox = document.getElementById("rssBox");
  var divs = rssBox.getElementsByTagName("div");

  if(divs.length < 1) return;

  if(++currItem >= divs.length) currItem = 0;
  if(currItem == 0)
    prevItem = divs.length - 1;
  else
    prevItem = currItem - 1;

  var currDiv = divs[currItem];
  var prevDiv = divs[prevItem];
  currDiv.style.zIndex = 1001;
  prevDiv.style.zIndex = 1000;

  xPos = parseInt(currDiv.parentNode.offsetWidth);
  currDiv.style.left = xPos + "px";
  currDiv.style.display = "block";

  slideDiv(prevItem, currItem);
}

function slideDiv(prevItem, currItem)
{
  var rssBox = document.getElementById("rssBox");
  var divs = rssBox.getElementsByTagName("div");
  var currDiv = divs[currItem];
  var prevDiv = divs[prevItem];

  xPos = parseInt(currDiv.style.left);
  xPos -= slideStep;
  if(xPos < rssBoxPadding){
    xPos = rssBoxPadding;
    prevDiv.style.display = "none";
    currDiv.style.left = xPos + "px";
    setTimeout("startRSSShow();", timeout * 1000);
  }
  else{
    currDiv.style.left = xPos + "px";
    setTimeout("slideDiv(prevItem, currItem);", slideSpeed);
  }
}

function onComplete(text, xml)
{
  if(text == 'error'){
    var rssDiv = document.getElementById("rssBox");
    rssDiv.innerHTML = "Wiadomości RSS nie są dostępne.";
  }
  else{
    var rssBox = document.getElementById("rssBox");
    rssBox.innerHTML = "";
    items = text.split("\n\n");
    var count = 0;
    for(i = 0; i < items.length; i++){
      elements = items[i].split("\n");

      var div = document.createElement("div");

      if(count > 0) div.style.display = "none"
      else div.style.display = "block";

      div.id = "rssDiv" + count++;
      div.className = "rssBoxDiv";

      rssBox.appendChild(div);
      div.style.width = (div.parentNode.clientWidth - 2 * 
                         rssBoxPadding) + "px";
      div.style.height = div.parentNode.offsetHeight + "px";

      var pTitle = document.createElement("p");
      pTitle.className = "pTitle";
      pTitle.innerHTML = elements[0];
      div.appendChild(pTitle);

      var pDate = document.createElement("p");
      pDate.className = "pDate";
      pDate.innerHTML = elements[1];
      div.appendChild(pDate);

      var pDescription = document.createElement("p");
      pDescription.className = "pDescription";
      pDescription.innerHTML = elements[3];
      div.appendChild(pDescription);

      var pLink = document.createElement("a");
      pLink.className = "pLink";
      pLink.innerHTML = "Więcej";
      pLink.href = elements[2];
      div.appendChild(pLink);
    }
    setTimeout("startRSSShow();", timeout * 1000);
  }
}

function onEnd()
{
}
